unit Main;

//################################################
interface uses Kernel;
//################################################

procedure EntryProc() stdcall;

//################################################
implementation
//################################################

{$LINK 'Main.obj'}

function StrCpyA(pDst,pSrc:PCHAR) : NAT32; external;
function SeekLast(ppChar:PCHAR; Char:CHAR) : BOOL32; external;

//================================================

type

	App = record
		class procedure Exit(); static; inline;
	end;

class procedure App.Exit;
begin
	ExitProcess(0);
end;

//================================================

type

	Opt = record
		class var fNoRepl : BOOL32;
	end;

//================================================

type

	Cmd = record
	private
		const Max_Arg = 1;
		class var pArgs : array [0..Max_Arg] of PCHAR;
		class procedure Parse(); static;
	strict private
		class procedure GetArgs(); static;
	end;

class procedure Cmd.GetArgs;
asm
	push	edi
	push	esi
	call	GetCommandLineA
	mov	esi, eax
	mov	edi, offset pArgs
	xor	ecx, ecx
	mov	edx, $2220 // ' "'
	jmp	@loop
.ALIGN 16
@loop:
	mov	al, [esi]
	inc	esi
	test	al, al
	jz		@fin
	cmp	al, dh // if '"'
	je		@quote
	cmp	al, dl // if ' '
	je		@loop
//@symb:
	lea	eax, [esi-1]
	inc	ecx
	mov	[edi], eax
	add	edi, 4
	jmp	@loop_s
.ALIGN 16
@loop_s:
	mov	al, [esi]
	inc	esi
	test	al, al
	jz		@fin
	cmp	al, dl // if ' '
	jne	@loop_s
	mov	[esi-1], ch
	cmp	cl, Max_Arg
	jna	@loop
	jmp	@fin
@quote:
	mov	[edi], esi
	inc	ecx
	add	edi, 4
	jmp	@loop_q
.ALIGN 16
@loop_q:
	mov	al, [esi]
	inc	esi
	test	al, al
	jz		@fin
	cmp	al, dh // if '"'
	jne	@loop_q
	mov	[esi-1], ch
	cmp	cl, Max_Arg
	jna	@loop
@fin:
//	mov	[cArgs], ecx
	pop	esi
	pop	edi
end;

class procedure Cmd.Parse;
var
	pch : PCHAR;
begin
	GetArgs();
	pch:= Cmd.pArgs[1];
	if (pch <> NIL) and (pch^ = '/') then begin
		inc(pch, 1);
		Opt.fNoRepl:= not ((PNAT32(pch)^ and $FFFF) = $0052); // 'R'#0
	end else Opt.fNoRepl:= TRUE;
end;

//================================================

procedure VerToId(pVer:PWCHAR; pBuf:PCHAR); external;

function MakeDirName(pBuffer,pFileName:PCHAR) : BOOL32;
label close;
const
	qw_sion = $006E006F00690073; // U'sion'
	b_max = 16383;
var
	i, tmp : NAT32;
	hfile : HANDLE;
	pwch : PWCHAR;
	buf : array [0..b_max] of BYTE;
begin
	result:= FALSE;
	hfile:= CreateFileA(pFileName, $80000000, $00, NIL, $03, $80, NULL);
	if (hfile = HANDLE(-1)) then exit;
	if (SetFilePointer(hfile, -b_max, NIL, $02) = $FFFFFFFF) then goto close;
	if not ReadFile(hfile, @buf, sizeof(buf), @tmp, NIL) then goto close;
	i:= b_max - 12; // 12 = sizeof(NAT64) + 4;
	repeat
		pwch:= @buf[i];
		if (PNAT64(pwch)^ = qw_sion) then begin
			inc(NAT32(pwch), 10);
			if (PNAT8(pwch)^ = 0) then inc(NAT32(pwch), 2);
			break;
		end;
		dec(i);
		if (i = 0) then goto close;
	until FALSE;
	VerToId(pwch, pBuffer);
	result:= TRUE;

close:
	CloseHandle(hfile);
end;

var

	sz_TCmExe : array [0..12] of CHAR = 'TotalCmd.exe';
	sz_TCmIni : array [0..10] of CHAR = 'WinCmd.ini';
	sz_FTPIni : array [0..11] of CHAR = 'WCX_FTP.ini';

var

	szCmLine : array [0..1023] of CHAR;
	szTmpDir : array [0..259] of CHAR;

procedure LaunchTC();
label error;
var
	pos_cmd, pos_dst : PCHAR;
	szdir : array [0..31] of CHAR;
	hfile : HANDLE;
	buf : array [0..1023] of CHAR;
	ffd : WIN32_FIND_DATAA;
begin
	GetModuleFileNameA(NULL, @szCmLine, 260);
	pos_cmd:= @szCmLine;
	SeekLast(@pos_cmd, '\');
	inc(pos_cmd);
	pos_cmd^:= #0;
	SetCurrentDirectoryA(@szCmLine);
	hfile:= FindFirstFileA(@sz_TCmIni, @ffd);
	if (hfile = HANDLE(-1)) then goto error;
	FindClose(hfile);
	inc(pos_cmd, StrCpyA(pos_cmd, @sz_TCmExe));
	if not MakeDirName(@szdir, @szCmLine) then goto error;

	pos_dst:= @szTmpDir;
	inc(pos_dst, GetEnvironmentVariableA('TEMP', pos_dst, 260));
	pos_dst^:= '\';
	inc(pos_dst);
	inc(pos_dst, StrCpyA(pos_dst, @szdir));
	if not CreateDirectoryA(@szTmpDir, NIL) and (GetLastError() <> 183) then begin
		goto error;
	{	pos_dst:= @szTmpDir;
		inc(pos_dst, GetEnvironmentVariableA('windir', pos_dst, 260));
		inc(pos_dst, StrCpyA(pos_dst, '\Temp\'));
		inc(pos_dst, StrCpyA(pos_dst, @szdir));
		CreateDirectoryA(@szTmpDir, NIL); }
	end;

	pos_dst^:= '\';
	inc(pos_dst);
	hfile:= FindFirstFileA('*.ini', @ffd);
	if (hfile = HANDLE(-1)) then goto error;
	StrCpyA(pos_dst, @ffd.cFileName);
	CopyFileA(@ffd.cFileName, @szTmpDir, Opt.fNoRepl);
	while FindNextFileA(hfile, @ffd) do begin
		StrCpyA(pos_dst, @ffd.cFileName);
		CopyFileA(@ffd.cFileName, @szTmpDir, Opt.fNoRepl);
	end;
	FindClose(hfile);
{	StrCpyA(pos_dst, @sz_TCmIni);
	SetFileAttributesA(@szTmpDir, $00); }
	pos_dst^:= #0;

	inc(pos_cmd, StrCpyA(pos_cmd, ' "/i='));
	inc(pos_cmd, StrCpyA(pos_cmd, @szTmpDir));
	inc(pos_cmd, StrCpyA(pos_cmd, @sz_TCmIni));
	inc(pos_cmd, StrCpyA(pos_cmd, '" "/F='));
	inc(pos_cmd, StrCpyA(pos_cmd, @szTmpDir));
	inc(pos_cmd, StrCpyA(pos_cmd, @sz_FTPIni));
	pos_cmd^:= '"';

	WinExec(@szCmLine, $05);
	exit;

error:
	FormatMessageA($1000, NIL, GetLastError(), $00, @buf, sizeof(buf), NIL);
end;

//================================================

procedure EntryProc;
begin
	Cmd.Parse();
	LaunchTC();
	App.Exit();
end;

end.
